section .text
org 0x100  ; Origin, standard for .COM files

start:
    ; Switch to 320x200 256-color mode (VGA Mode 13h)
    mov ah, 0x00
    mov al, 0x13
    int 0x10

    ; Initialize AL with the first color (16)
    mov al, 16

loop_color:
    ; Load video memory segment using push/pop
    push 0xA000
    pop es
    xor di, di       ; DI register to 0, start of video memory

    ; Use CX as the counter, since there are 320*200 = 64000 pixels
    mov cx, 320*200

fill_screen:
    ; Store AL (color) into ES:DI
    stosb

    ; Loop until all pixels are filled
    loop fill_screen

    ; Wait for about a second
    call delay

    ; Increment color
    inc al

    ; Check if we've passed color 31 and need to wrap around to 16
    cmp al, 32
    jb skip_reset
    mov al, 16
skip_reset:

    ; Loop again with a different color
    jmp loop_color

; Delay for approximately a second
delay:
    push bx
    push cx
    push dx
    mov bx, 0x04  ; number of loops, change for fine tuning
delay_outer:
    mov cx, 0xFFFF
delay_inner:
    nop
    nop
    nop
    nop
    loop delay_inner
    dec bx
    jnz delay_outer
    pop dx
    pop cx
    pop bx
    ret